"""Exceptions for the web interface."""

from sipb_xen_database import Machine

class MyException(Exception):
    """Base class for my exceptions"""
    pass

class InvalidInput(MyException):
    """Exception for user-provided input is invalid but maybe in good faith.

    This would include setting memory to negative (which might be a
    typo) but not setting an invalid boot CD (which requires bypassing
    the select box).
    """
    def __init__(self, err_field, err_value, expl=None):
        MyException.__init__(self, expl)
        self.err_field = err_field
        self.err_value = err_value

class CodeError(MyException):
    """Exception for internal errors or bad faith input."""
    pass

import controls

class Global(object):
    """Global state of the system, to avoid duplicate remctls to get state"""
    def __init__(self, user):
        self.user = user

    def __get_uptimes(self):
        if not hasattr(self, '_uptimes'):
            self._uptimes = controls.getUptimes(Machine.select())
        return self._uptimes
    uptimes = property(__get_uptimes)

    def clear(self):
        """Clear the state so future accesses reload it."""
        for attr in ('_uptimes', ):
            if hasattr(self, attr):
                delattr(self, attr)

g = Global(None)
