MAX_MEMORY_TOTAL = 512
MAX_MEMORY_SINGLE = 512
MAX_DISK_TOTAL = 50
MAX_DISK_SINGLE = 50
MAX_VMS_TOTAL = 10
MAX_VMS_ACTIVE = 4

class Owner(object):
    def __repr__(self):
        a = self.ram_quota_total
        b = self.ram_quota_single
        c = self.disk_quota_total
        d = self.disk_quota_single
        e = self.vms_quota_total
        f = self.vms_quota_active
        if not a:
            a = MAX_MEMORY_TOTAL
        if not b:
            b = MAX_MEMORY_SINGLE
        if not c:
            c = MAX_DISK_TOTAL
        if not d:
            d = MAX_DISK_SINGLE
        if not e:
            e = MAX_VMS_TOTAL
        if not f:
            f = MAX_VMS_ACTIVE
        return """<Owner %s: ram_quota_total=%s MB ram_quota_single=%s MB
disk_quota_total=%s GB disk_quota_single=%s GB
vms_quota_total=%s vms_quota_active=%s >""" % (self.owner_id, a,b,c,d,e,f)
    def getMemoryQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.ram_quota_total
            if quota_total == None:
                quota_total = MAX_MEMORY_TOTAL
            quota_single = owner_info.ram_quota_single
            if quota_single == None:
                quota_single = MAX_MEMORY_SINGLE
        else:
            quota_total = MAX_MEMORY_TOTAL
            quota_single = MAX_MEMORY_SINGLE
        return (quota_total, quota_single)
    getMemoryQuotas = staticmethod(getMemoryQuotas)
    def getDiskQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.disk_quota_total
            if quota_total == None:
                quota_total = MAX_DISK_TOTAL
            quota_single = owner_info.disk_quota_single
            if quota_single == None:
                quota_single = MAX_DISK_SINGLE
        else:
            quota_total = MAX_DISK_TOTAL
            quota_single = MAX_DISK_SINGLE
        return (quota_total, quota_single)
    getDiskQuotas = staticmethod(getDiskQuotas)
    def getVMQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.vms_quota_total
            if quota_total == None:
                quota_total = MAX_VMS_TOTAL
            quota_active = owner_info.vms_quota_active
            if quota_active == None:
                quota_active = MAX_VMS_ACTIVE
        else:
            quota_total = MAX_VMS_TOTAL
            quota_active = MAX_VMS_ACTIVE
        return (quota_total, quota_active)
    getVMQuotas = staticmethod(getVMQuotas)
