from pydhcplib import dhcp_constants
from datetime import datetime, timedelta
from sqlobject import *



def init(uri) :
	global Scopes,Options,Leases,Users,Rights
	connection = connectionForURI(uri)


        class Scopes(SQLObject):
            _connection = connection
            first = StringCol(length=15,default="0.0.0.0")
            last = StringCol(length=15,default="0.0.0.0")
            subnet = StringCol(length=18,default="0.0.0.0/32")
            chaddr = StringCol(length=17,default="")
            identifier = StringCol(length=64,default="")
            name  = StringCol(length=16,default="default_scope")
            plugins = StringCol(length=64,default="")
    
        class Options(SQLObject):
            _connection = connection
            name = StringCol(default="")
	    uniq_constants = set(dhcp_constants.DhcpOptionsList)
            parameter = EnumCol(enumValues=uniq_constants)
            value = StringCol(default="")
    
        class Leases(SQLObject):
            _connection = connection
            server = StringCol(length=65)
            ipaddr = StringCol(length=15,default="Undefined")
            chaddr = StringCol(length=17,default="00:00:00:00:00:00")
            identifier = StringCol(length=64,default="")
            stime = DateTimeCol(default=datetime.now)
            etime = DateTimeCol(default=datetime.now)
            state = StringCol(length=15,default="active")
		
	class Users(SQLObject):
		_connection = connection
		identifier = StringCol(length=16,default="",unique=True)
		password = StringCol(length=64,default="")
		
	class Rights(SQLObject):
		_connection = connection
		identifier = StringCol(default="")
		subnet = StringCol(length=18,default="0.0.0.0/32")
		
