#!/bin/bash
set -e

SVN=${1:-/mit/xvm/svn}

mako-render rules.mako > rules

rm git -rf
mkdir git
cd git

sed -n 's/^create repository // p' ../rules | while read repo; do
    mkdir -p "$repo" && GIT_DIR="$repo" git init --bare
done

svn-all-fast-export --identity-map <(sed 's/= //' ../authors) ../rules "$SVN"

sed -n 's/^create repository // p' ../rules | while read repo; do
    ! [ -e "$repo/refs/heads/tags" ] || \
	cp -a "$repo/refs/heads/tags/." "$repo/refs/tags" && \
	rm -rf "$repo/refs/heads/tags"
done
