# For a package which only configures another, "parent" package.
#
# Global variable PARENTPACKAGE names parent; may be array
# for zero or many parents.
#
# Global variable PACKAGE names this package, for log message.
#
# Requires bash.

. /lib/init/vars.sh
. /lib/lsb/init-functions
. /lib/init/gen-files.sh

config_init () {
  case "$1" in
    start|reload|force-reload|restart)
      log_begin_msg "Reloading config for $PACKAGE"
      gen_files
      log_end_msg $?
      for p in "${PARENTPACKAGE[@]}"; do
        invoke-rc.d "$p" "$1"
      done
      ;;
    stop)
      for p in "${PARENTPACKAGE[@]}"; do
        invoke-rc.d "$p" "$1"
      done
      ;;
    *)
      log_success_msg "Usage: /etc/init.d/$PACKAGE {start|reload|force-reload|restart|stop}"
      ;;
  esac
}
