/*
 * The general idea is from the following A List Apart article:
 * http://www.alistapart.com/articles/zebratables/
 *
 * The structure is inspired by the code fragment they supply, but the
 * code here is significantly cleaner. It also colors every two lines
 * rather than every line, since XVM uses two rows for each item.
 */

function stripe(table, darkClass, lightClass) {
    for (var i = 0; i < table.rows.length; i++ ) {
        /* The header row should be light; the next two are dark. */
        if (i%4 == 1 || i%4 == 2)
            table.rows[i].className += ' ' + darkClass;
        else if (lightClass)
            table.rows[i].className += ' ' + lightClass;
    }
}
