<%
from invirt.config import structs as cfg
hostname = cfg.web.hostname
errmail  = cfg.web.errormail
svnpath  = cfg.svn.repopath
%>
Listen 1111
<VirtualHost *:1111>
	ServerAdmin ${errmail}
	ServerName ${hostname}:1111
	
	<Directory />
		Options FollowSymLinks
		AllowOverride None
	</Directory>
	<Location />
		DAV svn
		SVNPath ${svnpath}
		AuthType Basic
		AuthName "xvm.mit.edu subversion repository"
		AuthUserFile /etc/apache2/dav_svn.passwd
		<LimitExcept GET PROPFIND OPTIONS REPORT>
			Require valid-user
		</LimitExcept>
	</Location>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/svn_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ssl/server.crt
	SSLCertificateKeyFile ssl/server.key
</VirtualHost>
