"""Exceptions for the web interface."""

import time
from invirt import database
from invirt.database import Machine, MachineAccess

import controls

def cachedproperty(func):
    name = '__cache_' + func.__name__ + '_' + str(id(func))
    def getter(self):
        try:
            return getattr(self, name)
        except AttributeError:
            value = func(self)
            setattr(self, name, value)
            return value
    return property(getter)

class State(object):
    """State for a request"""
    def __init__(self, user, isadmin=False):
        self.username = user
        self.isadmin = isadmin

    def getMachines(self):
        if self.isadmin:
            return Machine.query().join('acl').all()
        else:
            return Machine.query().join('acl').filter_by(user=self.username)

    machines = cachedproperty(getMachines)
    xmlist_raw = cachedproperty(lambda self: controls.getList())
    xmlist = cachedproperty(lambda self:
                                dict((m, self.xmlist_raw[m.name])
                                     for m in self.machines
                                     if m.name in self.xmlist_raw))

    def clear(self):
        """Clear the state so future accesses reload it."""
        for attr in list(self.__dict__):
            if attr.startswith('__cache_'):
                delattr(self, attr)
