<%
from invirt.config import structs as cfg
hostname = cfg.web.hostname
errmail  = cfg.web.errormail
tracuri  = cfg.trac.uri
%>
Listen 442
Listen 446

<%def name="invirt_webinterface()">
	DocumentRoot /var/www/invirt-web
	<Directory /var/www/invirt-web>
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>
	<Location />
${caller.body()}
	</Location>

	RewriteEngine On
	RewriteRule ^/favicon.ico - [L]
	RewriteRule ^/static(.*) - [L]
	RewriteRule ^/overlord/static(.*) /static/$1 [L]
	RewriteRule ^/admin/static(.*) /static/$1 [L]
	RewriteRule ^/trac.fcgi(.*) - [L]
	RewriteRule ^/trac/chrome/common(.*) /usr/share/trac/htdocs$1 [L]
	RewriteRule ^/trac(.*) /var/www/trac/trac.fcgi$1 [L]
	RewriteRule ^/var(.*) - [L]
	RewriteRule ^/wiki(.*) - [L]
	RewriteRule ^/kill.cgi - [L]
	RewriteRule ^/~ - [L]
	RewriteRule ^/(.*) /var/www/invirt-web/main.fcgi/$1 [L]

	RewriteLog /var/log/apache2/rewrite.log
	RewriteLogLevel 0 

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ssl/server.crt
	SSLCertificateKeyFile ssl/server.key
	
	SSLCACertificateFile ssl/mitCAclient.pem
	SSLVerifyDepth 10

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0

	Redirect /wiki ${tracuri}	
</%def>
<VirtualHost *:443>
	ServerAdmin ${errmail}
	ServerName ${hostname}:443
	<%call expr="invirt_webinterface()">
		Require valid-user
		AuthType SSLCert
		AuthSSLCertVar SSL_CLIENT_S_DN_Email
		AuthSSLCertStripSuffix "@MIT.EDU"
	</%call>
	SSLVerifyClient require
</VirtualHost>
<VirtualHost *:442>
	ServerAdmin ${errmail}
	ServerName ${hostname}:442
	<%call expr="invirt_webinterface()">
		Require valid-user
		AuthType Kerberos
		KrbMethodNegotiate on
		KrbMethodK5Passwd off
		KrbAuthoritative off
		KrbAuthRealms ${cfg.authn[0].realm}
		Krb5Keytab /etc/invirt/keytab
		KrbSaveCredentials off
	</%call>
	SSLVerifyClient optional
</VirtualHost>

<VirtualHost *:446>
	ServerAdmin ${errmail}
	ServerName ${hostname}:446
	
	DocumentRoot /var/www/invirt-web
	<Directory />
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_nocert_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ssl/server.crt
	SSLCertificateKeyFile ssl/server.key
	
	SSLVerifyClient none

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0	
</VirtualHost>
