#!/bin/bash

if [ "$(ls /etc/invirt/vnc-cert.d)" == "" ]; then
    echo "E: No certs in /etc/invirt/vnc-cert.d/" >&2
    echo "   Put certificates for all Invirt VNC proxy servers in" >&2
    echo "   /etc/invirt/vnc-cert.d, then run this script again" >&2
    exit 1
fi

TMP_DIR="$(mktemp -d)"
for i in $(ls /etc/invirt/vnc-cert.d/*.crt); do
    keytool -noprompt -alias "${i%.crt}" -file "/etc/invirt/vnc-cert.d/$i" \
        -keystore "$TMP_DIR/trust.store" -storepass "foobar"
done

jar uf /usr/share/invirt-vnc-client/VncViewer.jar -C "$TMP_DIR" trust.store

rm -rf "$TMP_DIR"
