#!/bin/sh
# dispatch-ACTION.sh MACHINE
#
# remctl should have already verified that the user is authorized to
# control the machine.  So, we just need to execute the action requested.
#
# $0 and $1 come from the trusted remctl source.
#
# $2 and so on are user-provided, and thus sketchy.  I don't think we
# need them for this script.

ACTION=$(echo "$0" | awk -F'.' '{print $2}')
MACHINE=$1
echo "$ACTION"

case "$ACTION" in
    reboot|list|vcpu-list|destroy|create|uptime)
        xm "$ACTION" "$MACHINE"
        exit 0
	;;
    *)
        echo "ERROR: Invalid Command"
        exit 1
        ;;
esac
