//
//  Copyright (C) 2002 Constantin Kaplinsky, Inc.  All Rights Reserved.
//  Copyright 2007 MIT Student Information Processing Board
//
//  This is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This software is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this software; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//

//
// VNCProxySocket.java together with VNCProxySocketFactory.java
// implement an alternate way to connect to VNC servers via one or two
// VNCProxy proxies supporting the VNCProxy VNCCONNECT method.
//

import java.net.*;
import java.io.*;

class VNCProxyConnectSocket extends Socket {

  public VNCProxyConnectSocket(String host, int port,
                               String vmname, String authtoken)
    throws IOException {

    // Connect to the specified HTTP proxy
    super(host, port);

    // Send the CONNECT request
    getOutputStream().write(("CONNECTVNC " + vmname +
                             " VNCProxy/1.0\r\nAuth-token: " + authtoken +
                             "\r\n\r\n").getBytes());

    // Read the first line of the response
    DataInputStream is = new DataInputStream(getInputStream());
    String str = is.readLine();

    // Check the HTTP error code -- it should be "200" on success
    if (!str.startsWith("VNCProxy/1.0 200 ")) {
      if (str.startsWith("VNCProxy/1.0 "))
        str = str.substring(13);
      throw new IOException("Proxy reports \"" + str + "\"");
    }

    // Success -- skip remaining HTTP headers
    do {
      str = is.readLine();
    } while (str.length() != 0);
  }
}

