# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA

import sys
from logging import *



class EventLogger:
    def __init__(self,logtype="stdout",loglevel=WARNING,option={}):
        self.loglevel = loglevel
        self.logtype = logtype

        self.info = INFO
        self.debug = DEBUG
        self.warn = WARN
        self.error = ERROR
        self.critical = CRITICAL


        self.logger = getLogger('SipbXenDhcpServer')

        if logtype == "file" :
            # into file logger
            handler = FileHandler(option["log_file"])
            
        elif logtype == "syslog" :
            handler = SysLogHandler((option["log_host"],option["log_port"]))

        elif logtype == "http" :
            handler = HTTPHandler(option["log_host"],option["log_url"],option["log_method"])

        else : # logtype == "stdout" :
            handler = StreamHandler()



        handler.setFormatter(Formatter('%(asctime)s %(levelname)s %(message)s'))
        self.logger.addHandler(handler) 
        self.logger.setLevel(loglevel)

    def Output(self,level,infostring) :
        self.logger.log(level,infostring)

def init(logtype,level,path):
    global Log
    
    Log = EventLogger(logtype,eval(level),path)
    Log.Output(INFO,"EventLogger : Started.")
